<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getReservationListByParams(array|GetReservationList\ReservationQueryDto $params)
 * @method getReservationStoreListByParams(array|GetReservationStoreList\ReservationStoreQueryDto $params)
 * @method checkReserveTimeByParams(array|CheckReserveTime\ReservationTimeCheckDto $params)
 * @method getOccupyResultByParams(array|GetOccupyResult\ReservationTimeCheckDto $params)
 */
class Reservation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店的排单表
     *
     * @var  GetReservationList\ReservationQueryDto $reservationQueryDto $reservationQueryDto
     * @throws  \Exception
     * @return  array
     */
    public static function getReservationList (GetReservationList\ReservationQueryDto $reservationQueryDto) {
        return self::getClass()->getReservationList($reservationQueryDto);
    }


    /**
     * 获取可预约的门店
     *
     * @var  GetReservationStoreList\ReservationStoreQueryDto $reservationStoreQueryDto $reservationStoreQueryDto
     * @throws  \Exception
     * @return  array
     */
    public static function getReservationStoreList (GetReservationStoreList\ReservationStoreQueryDto $reservationStoreQueryDto) {
        return self::getClass()->getReservationStoreList($reservationStoreQueryDto);
    }


    /**
     * 验证时间点是否被占用
     *
     * @var  CheckReserveTime\ReservationTimeCheckDto $reservationTimeCheckDto $reservationTimeCheckDto
     * @throws  \Exception
     * @return  array
     */
    public static function checkReserveTime (CheckReserveTime\ReservationTimeCheckDto $reservationTimeCheckDto) {
        return self::getClass()->checkReserveTime($reservationTimeCheckDto);
    }


    /**
     * 获取占点结果
     *
     * @var  GetOccupyResult\ReservationTimeCheckDto $reservationTimeCheckDto $reservationTimeCheckDto
     * @throws  \Exception
     * @return  array
     */
    public static function getOccupyResult (GetOccupyResult\ReservationTimeCheckDto $reservationTimeCheckDto) {
        return self::getClass()->getOccupyResult($reservationTimeCheckDto);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Order\Reservation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Order\Reservation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}