<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getReservationListByParams(array $params)
 * @method checkReserveTimeByParams(array $params)
 */
class Reservation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取单门店排单表
     *
     * @support  int $storeId 门店ID [ require true ]
     * @support  string $dateStart 开始日期 [ require true ]
     * @support  string $dateEnd 结束日期 [ require true ]
     * @support  array $productGroup 产品数组 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getReservationList () {
        return self::getClass()->getReservationList();
    }

    /**
     * 验证时间点是否被占用
     *
     * @support  int $storeId 预约门店 [ require true ]
     * @support  array $productGroup 产品数组 require false
     * @support  string $reserveTime 预约时间 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function checkReserveTime () {
        return self::getClass()->checkReserveTime();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Order\Reservation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Order\Reservation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}