<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method cronSendOrderReserveTimeMessageByParams(array $params)
 * @method cronSendOrderSnMessageByParams(array $params)
 * @method cronOrderAutoServiceCompleteByParams(array $params)
 * @method cronOrderSaleSkuAutoServiceCompleteByParams(array $params)
 * @method cronOrderUpgradeSkuAutoServiceCompleteByParams(array $params)
 * @method cronOrderAppendUpgradeSkuAutoServiceCompleteByParams(array $params)
 * @method cronOrderWaitLookPhotoAutoServiceCompleteByParams(array $params)
 * @method cronOrderOnlineLookPhotoAutoServiceCompleteByParams(array $params)
 */
class OrderCron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 预约时间提醒
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function cronSendOrderReserveTimeMessage () {
        return self::getClass()->cronSendOrderReserveTimeMessage();
    }

    /**
     * 订单评价提醒
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function cronSendOrderSnMessage () {
        return self::getClass()->cronSendOrderSnMessage();
    }

    /**
     * 看片完成15天后订单服务完成
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderAutoServiceComplete () {
        return self::getClass()->cronOrderAutoServiceComplete();
    }

    /**
     * 看片完成15天后拍摄产品服务完成
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderSaleSkuAutoServiceComplete () {
        return self::getClass()->cronOrderSaleSkuAutoServiceComplete();
    }

    /**
     * 看片完成15天后升级体验服务完成
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderUpgradeSkuAutoServiceComplete () {
        return self::getClass()->cronOrderUpgradeSkuAutoServiceComplete();
    }

    /**
     * 创建订单37天后追加的升级体验服务完成
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderAppendUpgradeSkuAutoServiceComplete () {
        return self::getClass()->cronOrderAppendUpgradeSkuAutoServiceComplete();
    }

    /**
     * 订单待看片37天后自动完成
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderWaitLookPhotoAutoServiceComplete () {
        return self::getClass()->cronOrderWaitLookPhotoAutoServiceComplete();
    }

    /**
     * 订单在线看片中37天后自动完成
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderOnlineLookPhotoAutoServiceComplete () {
        return self::getClass()->cronOrderOnlineLookPhotoAutoServiceComplete();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Cron\OrderCron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Cron\OrderCron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}