<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Question;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getNpsStatusByParams(array $params)
 * @method createNpsByParams(array|CreateNps\NpsCreateDto $params)
 */
class Nps {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取NPS状态
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function getNpsStatus () {
        return self::getClass()->getNpsStatus();
    }

    /**
     * 提交NPS问卷
     *
     * @var  CreateNps\NpsCreateDto $npsCreateDto $npsCreateDto
     * @throws  \Exception
     * @return  bool
     */
    public static function createNps (CreateNps\NpsCreateDto $npsCreateDto) {
        return self::getClass()->createNps($npsCreateDto);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Question\Nps');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Question\Nps');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}