<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllCouponsByParams(array $params)
 * @method bindPreferentialByParams(array $params)
 */
class Coupon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取所有的优惠券
     *
     * @support  string $statusType 优惠券状态类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllCoupons () {
        return self::getClass()->getAllCoupons();
    }

    /**
     * 用户绑定优惠卷
     *
     * @support  string $code 兑换码 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function bindPreferential () {
        return self::getClass()->bindPreferential();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Preferential\Coupon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Preferential\Coupon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}