<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method cronSendOrderReserveTimeMessageByParams(array $params)
 * @method cronSendOrderSnMessageByParams(array $params)
 * @method cronOrderAutoServiceCompleteByParams(array $params)
 * @method cronOrderAutoWaitLookPhotoCompleteByParams(array $params)
 * @method cronOrderAutoOnlineLookPhotoCompleteByParams(array $params)
 */
class OrderCron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 预约时间提醒
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function cronSendOrderReserveTimeMessage () {
        return self::getClass()->cronSendOrderReserveTimeMessage();
    }

    /**
     * 订单评价提醒
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function cronSendOrderSnMessage () {
        return self::getClass()->cronSendOrderSnMessage();
    }

    /**
     * 15天服务完成
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderAutoServiceComplete () {
        return self::getClass()->cronOrderAutoServiceComplete();
    }

    /**
     * 37天待看片自动完成
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderAutoWaitLookPhotoComplete () {
        return self::getClass()->cronOrderAutoWaitLookPhotoComplete();
    }

    /**
     * 37天在线看片中自动完成
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderAutoOnlineLookPhotoComplete () {
        return self::getClass()->cronOrderAutoOnlineLookPhotoComplete();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Cron\OrderCron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Cron\OrderCron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}