<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hookOrderPaidMessageByParams(array $params)
 * @method hookOrderLookPhotoMessageByParams(array $params)
 * @method hookOrderLookPhotoCompleteOnlineMessageByParams(array $params)
 * @method hookOrderLookPhotoCompleteOfflineMessageByParams(array $params)
 */
class OrderMessageHook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单支付完成通知
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookOrderPaidMessage () {
        return self::getClass()->hookOrderPaidMessage();
    }

    /**
     * 订单看片通知
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  string $type 类型 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function hookOrderLookPhotoMessage () {
        return self::getClass()->hookOrderLookPhotoMessage();
    }

    /**
     * 在线看片完成通知
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookOrderLookPhotoCompleteOnlineMessage () {
        return self::getClass()->hookOrderLookPhotoCompleteOnlineMessage();
    }

    /**
     * 门店看片完成通知
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookOrderLookPhotoCompleteOfflineMessage () {
        return self::getClass()->hookOrderLookPhotoCompleteOfflineMessage();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'MessageHook\OrderMessageHook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'MessageHook\OrderMessageHook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}