<?php
namespace Mainto\Bridge\Invokes\ProjectExpense\Invoice;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getInvoiceStoresByParams(array $params)
 * @method historyByParams(array|\Mainto\Bridge\Structs\ProjectExpense\Invoice\Cmd\InvoiceHistoryListCmd $params)
 * @method getInvoiceListByParams(array|\Mainto\Bridge\Structs\ProjectExpense\Invoice\Cmd\InvoiceListCmd $params)
 * @method createSimpleByParams(array|\Mainto\Bridge\Structs\ProjectExpense\Invoice\Cmd\InvoiceCreateCmd $params)
 * @method batchCheckOrderInvoiceStatusByParams(array|\Mainto\Bridge\Structs\ProjectExpense\Bridge\Order\Cmd\CheckOrderInvoiceStatusCmd $params)
 */
class Invoice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取可开票的门店数据
     *
     * @param  string $module 模块名:family,himo,mantu [ require true ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectExpense\Invoice\DTO\InvoiceStoreItemDTO[]
     */
    public static function getInvoiceStores (string $module, int $userId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getInvoiceStores([
                            "module" => $module,
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectExpense\Invoice\DTO\InvoiceStoreItemDTO[]"
        );
    }

    /**
     * 获取发票历史列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectExpense\Invoice\Cmd\InvoiceHistoryListCmd $invoiceHistoryListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectExpense\Invoice\DTO\History\InvoiceHistoryListDTO
     */
    public static function history (\Mainto\Bridge\Structs\ProjectExpense\Invoice\Cmd\InvoiceHistoryListCmd $invoiceHistoryListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->history($invoiceHistoryListCmd),
            "\Mainto\Bridge\Structs\ProjectExpense\Invoice\DTO\History\InvoiceHistoryListDTO"
        );
    }


    /**
     * 获取可开票的发票列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectExpense\Invoice\Cmd\InvoiceListCmd $invoiceListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectExpense\Invoice\DTO\OrderList\InvoiceOrderListDTO
     */
    public static function getInvoiceList (\Mainto\Bridge\Structs\ProjectExpense\Invoice\Cmd\InvoiceListCmd $invoiceListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getInvoiceList($invoiceListCmd),
            "\Mainto\Bridge\Structs\ProjectExpense\Invoice\DTO\OrderList\InvoiceOrderListDTO"
        );
    }


    /**
     * 电子发票.开普票
     *
     * @var  \Mainto\Bridge\Structs\ProjectExpense\Invoice\Cmd\InvoiceCreateCmd $invoiceCreateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createSimple (\Mainto\Bridge\Structs\ProjectExpense\Invoice\Cmd\InvoiceCreateCmd $invoiceCreateCmd) {
        return self::getClass()->createSimple($invoiceCreateCmd);
    }


    /**
     * batchCheckOrderInvoiceStatus
     *
     * @var  \Mainto\Bridge\Structs\ProjectExpense\Bridge\Order\Cmd\CheckOrderInvoiceStatusCmd $checkCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectExpense\Invoice\DTO\OrderInvoiceStatusDTO
     */
    public static function batchCheckOrderInvoiceStatus (\Mainto\Bridge\Structs\ProjectExpense\Bridge\Order\Cmd\CheckOrderInvoiceStatusCmd $checkCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->batchCheckOrderInvoiceStatus($checkCmd),
            "\Mainto\Bridge\Structs\ProjectExpense\Invoice\DTO\OrderInvoiceStatusDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectExpense', 'Invoice\Invoice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectExpense', 'Invoice\Invoice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}