<?php
namespace Mainto\Bridge\Invokes\ProjectEbs\Organization;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method syncBeisenPositionByParams(array $params)
 * @method syncBeisenJobByParams(array $params)
 * @method syncBeisenJobLevelByParams(array $params)
 */
class Position {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 同步北森职位
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function syncBeisenPosition () {
        return self::getClass()->syncBeisenPosition();
    }

    /**
     * 同步北森职务
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function syncBeisenJob () {
        return self::getClass()->syncBeisenJob();
    }

    /**
     * 同步北森职级
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function syncBeisenJobLevel () {
        return self::getClass()->syncBeisenJobLevel();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectEbs', 'Organization\Position');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectEbs', 'Organization\Position');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}