<?php
namespace Mainto\Bridge\Invokes\ProjectEbs\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createAllocationByParams(array $params)
 * @method createReceiveByParams(array $params)
 */
class Stock {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建库存转移订单
     *
     * @support  string $allocationNo 库存转移单号 [ require true ]
     * @support  string $createdAt 创建时间 [ require true ]
     * @support  string $type 单据类型 自用or零售 [ require true ]
     * @support  int $fromStorageId 发货仓库ID [ require true ]
     * @support  int $fromDepartmentId 发货部门ID [ require true ]
     * @support  int $toStorageId 收货仓库ID [ require true ]
     * @support  int $toDepartmentId 收货部门ID [ require true ]
     * @support  int $createBy 创建人 [ require true ]
     * @support  string $remarks 备注 require false
     * @support  array $allocationItems 关联记录 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createAllocation () {
        return self::getClass()->createAllocation();
    }

    /**
     * 创建入库单
     *
     * @support  string $receiveNo 收货单号 [ require true ]
     * @support  string $relatedType 单据类型 采购or调拨 [ require true ]
     * @support  string $relatedNo 关联单号 采购order_no或调拨allocation_no [ require true ]
     * @support  string $createdAt 创建时间 [ require true ]
     * @support  string $remarks 备注 require false
     * @support  int $receiveBy 收货人 [ require true ]
     * @support  array $receiveItems 关联记录 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createReceive () {
        return self::getClass()->createReceive();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectEbs', 'Erp\Stock');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectEbs', 'Erp\Stock');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}