<?php
namespace Mainto\Bridge\Invokes\ProjectEbs\ThirdPart;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrderByParams(array $params)
 * @method queryOrderListByParams(array $params)
 * @method queryOrderDetailByParams(array $params)
 * @method orderStatusCallbackByParams(array $params)
 * @method getEditorParamsByParams(array $params)
 */
class CunXin {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 下单接口
     *
     * @support  array $params 下单数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrder () {
        return self::getClass()->createOrder();
    }

    /**
     * 订单列表查询
     *
     * @support  array $params 查询数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryOrderList () {
        return self::getClass()->queryOrderList();
    }

    /**
     * 订单详情查询
     *
     * @support  string $productionOrderId 生产订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryOrderDetail () {
        return self::getClass()->queryOrderDetail();
    }

    /**
     * 订单回调
     *
     * @support  string $notice_type 回调类型 [ require true ]
     * @support  array $notice_data 回调数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function orderStatusCallback () {
        return self::getClass()->orderStatusCallback();
    }

    /**
     * 获取寸心编辑页面参数
     *
     * @support  string $third_party_user_id 第三方用户唯一id [ require true ]
     * @support  string $third_project_id 创建订单接口返回的project_id [ require true ]
     * @support  string $production_order_id 创建订单接口返回的production_order_id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getEditorParams () {
        return self::getClass()->getEditorParams();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectEbs', 'ThirdPart\CunXin');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectEbs', 'ThirdPart\CunXin');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}