<?php
namespace Mainto\Bridge\Invokes\ProjectEbs\Logistics;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method queryLogisticsInfoByParams(array $params)
 */
class Logistics {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询物流信息
     *
     * @support  string $expressNo 物流单号 [ require true ]
     * @support  string $expressType 物流公司类型 require false
     * @support  string $senderPhone 发件人手机号。当物流类型是顺丰时必传 require false
     * @support  string $receiverPhone 收件人手机号。当物流类型是顺丰时必传 require false
     * @throws  \Exception
     * @return  array
     */
    public static function queryLogisticsInfo () {
        return self::getClass()->queryLogisticsInfo();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectEbs', 'Logistics\Logistics');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectEbs', 'Logistics\Logistics');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}