<?php
namespace Mainto\Bridge\Invokes\ProjectEbs\Organization;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createStoreByParams(array $params)
 * @method updateStoreByParams(array $params)
 * @method deleteStoreByParams(array $params)
 */
class Store {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增门店
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  int $departmentId 部门id [ require true ]
     * @support  string $name 门店名称 [ require true ]
     * @support  int $areaId 区域id [ require true ]
     * @support  string $storeType 门店类型 [ require true ]
     * @support  string $affiliateType 加盟类型 [ require true ]
     * @support  string $startAppointmentTime 每日开始预约时间 [ require true ]
     * @support  string $stopAppointmentTime 每日结束预约时间 [ require true ]
     * @support  int $serviceInterval 每次服务间隔(分钟) [ require true ]
     * @support  int $serviceTimes 每间隔同时服务数 [ require true ]
     * @support  string $startBusiness 开始营业时间 [ require true ]
     * @support  int $sort 排序权重 require false
     * @support  string $dianpingId 大众点评门店ID require false
     * @support  string $usePosStatus 拉卡拉启用状态 require false
     * @support  int $groupId 集团id require false
     * @support  int $provinceId 所在省份 [ require true ]
     * @support  array $extend 拓展信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createStore () {
        return self::getClass()->createStore();
    }

    /**
     * 修改门店
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  int $departmentId 部门id require false
     * @support  string $name 门店名称 require false
     * @support  int $areaId 区域id require false
     * @support  string $storeType 门店类型 require false
     * @support  string $affiliateType 加盟类型 require false
     * @support  string $startAppointmentTime 每日开始预约时间 require false
     * @support  string $stopAppointmentTime 每日结束预约时间 require false
     * @support  int $serviceInterval 每次服务间隔(分钟) require false
     * @support  int $serviceTimes 每间隔同时服务数 require false
     * @support  string $startBusiness 开始营业时间 require false
     * @support  int $sort 排序权重 require false
     * @support  string $dianpingId 大众点评门店ID require false
     * @support  string $usePosStatus 拉卡拉启用状态 require false
     * @support  int $groupId 集团id require false
     * @support  int $provinceId 所在省份 require false
     * @support  array $extend 拓展信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateStore () {
        return self::getClass()->updateStore();
    }

    /**
     * 删除门店
     *
     * @support  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteStore () {
        return self::getClass()->deleteStore();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectEbs', 'Organization\Store');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectEbs', 'Organization\Store');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}