<?php
namespace Mainto\Bridge\Invokes\ProjectEbs\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method syncMaterialCategoryByParams(array $params)
 * @method syncMaterialInfoByParams(array $params)
 * @method syncMaterialSkuByParams(array $params)
 * @method createOrUpdateGoodsByParams(array $params)
 */
class Material {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 定时任务(同步物料分类信息)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncMaterialCategory () {
        return self::getClass()->syncMaterialCategory();
    }

    /**
     * 定时同步物料信息(closed)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncMaterialInfo () {
        return self::getClass()->syncMaterialInfo();
    }

    /**
     * 同步物料信息
     *
     * @support  int $id 物料id [Original type uint] [ require true ]
     * @support  array $extraInfo 物料信息 
     * @support  int $skuId skuid [Original type uint] 
     * @support  array $skuExtraInfo sku信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncMaterialSku () {
        return self::getClass()->syncMaterialSku();
    }

    /**
     * 物料信息同步wms
     *
     * @support  string $name 名称 [ require true ]
     * @support  string $code 编码 [ require true ]
     * @support  string $skuCode sku编码 [ require true ]
     * @support  string $goodsType 货品类型 
     * @support  string $price 价格 [ require true ]
     * @support  string $size 规格 [ require true ]
     * @support  string $color 颜色 [ require true ]
     * @support  string $brcode 条码 
     * @support  string $unit 单位 [ require true ]
     * @support  string $updateDate 更新时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrUpdateGoods () {
        return self::getClass()->createOrUpdateGoods();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectEbs', 'Erp\Material');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectEbs', 'Erp\Material');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}