<?php
namespace Mainto\Bridge\Invokes\ProjectEbs\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createPurchaseOrderByParams(array $params)
 * @method createPurchaseDueByParams(array $params)
 * @method createPurchaseAdvanceByParams(array $params)
 * @method createPurchasePlanByParams(array $params)
 * @method createSalePlanByParams(array $params)
 * @method cancelOrderByParams(array $params)
 */
class Purchase {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建采购订单
     *
     * @support  string $orderNo 采购订单号 [ require true ]
     * @support  int $supplierId NS供应商ID [Original type uint] [ require true ]
     * @support  int $createBy 创建人 [Original type uint] [ require true ]
     * @support  string $createdAt 创建时间 [ require true ]
     * @support  string $remarks 备注 
     * @support  string $orderType 采购类型 [ require true ]
     * @support  array $orderItems 采购明细 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPurchaseOrder () {
        return self::getClass()->createPurchaseOrder();
    }

    /**
     * 创建应付账单
     *
     * @support  string $dueNo 应付账单号 [ require true ]
     * @support  int $createBy 创建人 [Original type uint] [ require true ]
     * @support  string $createdAt 创建时间 [ require true ]
     * @support  string $orderNo 采购订单号 [ require true ]
     * @support  int $supplierId NS供应商ID [Original type uint] [ require true ]
     * @support  string $supplierBankAccount 供应商账户 [ require true ]
     * @support  string $invoiceNumber 发票号 
     * @support  float $totalMoney 总金额 [Original type double] [ require true ]
     * @support  float $prepaidMoney 预付金额 [Original type double] [ require true ]
     * @support  float $paidMoney 实付金额 [Original type double] [ require true ]
     * @support  float $exceptTaxMoney 不含税金额 [Original type double] [ require true ]
     * @support  float $taxMoney 税额 [Original type double] [ require true ]
     * @support  array $dueItems 明细 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPurchaseDue () {
        return self::getClass()->createPurchaseDue();
    }

    /**
     * 创建预付款单
     *
     * @support  string $advanceNo 预付款单号 [ require true ]
     * @support  string $createdAt 创建时间 [ require true ]
     * @support  string $orderNo 采购订单号 [ require true ]
     * @support  int $createBy 创建人 [Original type uint] [ require true ]
     * @support  int $supplierId NS供应商ID [Original type uint] [ require true ]
     * @support  string $supplierBankAccount 供应商账户 [ require true ]
     * @support  float $prepaidMoney 预付金额 [Original type double] [ require true ]
     * @support  string $remarks 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPurchaseAdvance () {
        return self::getClass()->createPurchaseAdvance();
    }

    /**
     * 创建采购计划单
     *
     * @support  string $orderCode 采购计划号 [ require true ]
     * @support  string $supplierCode 供应商编码 [ require true ]
     * @support  string $warehouseCode 仓库编码 [ require true ]
     * @support  string $planDate 预计到货日期 [ require true ]
     * @support  string $remark remark 
     * @support  string $goodsOwner goodsOwner 
     * @support  array $detailList sku和数量的数组 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPurchasePlan () {
        return self::getClass()->createPurchasePlan();
    }

    /**
     * 创建销售计划单
     *
     * @support  string $orderCode 配货单号 [ require true ]
     * @support  string $bity 订单类型 [ require true ]
     * @support  string $warehouseCode 仓库编码 [ require true ]
     * @support  string $downDate 下单时间 
     * @support  string $payTime 支付时间 
     * @support  string $auditTime 审核时间(即生成通知单的时间) 
     * @support  string $isDeliveryPay 是否货到付款 
     * @support  string $goodsOwner 货主 
     * @support  string $logisticsCompanyCode 物流公司编码 [ require true ]
     * @support  string $amountReceivable 应收金额 
     * @support  string $actualPayment 实际支付 
     * @support  array $detailList sku和数量的数组 [ require true ]
     * @support  array $extraInfo 地址店铺等信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createSalePlan () {
        return self::getClass()->createSalePlan();
    }

    /**
     * JYCK:销售订单
     * XTRK:销售退货
     * CGRK:采购订单
     * CGTH:采购退货
     * TRAN:调拨计划
     *
     * @support  string $orderCode 取消单号 [ require true ]
     * @support  string $orderType 订单类型 TRAN:调拨计划|CGRK:采购订单 [ require true ]
     * @support  string $goodsOwner 货主 
     * @support  string $remark 备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelOrder () {
        return self::getClass()->cancelOrder();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectEbs', 'Erp\Purchase');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectEbs', 'Erp\Purchase');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}