<?php
namespace Mainto\Bridge\Invokes\ProjectEbs\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createPurchaseByParams(array $params)
 * @method changePurchaseStatusByParams(array $params)
 * @method createPurchaseOrderByParams(array $params)
 * @method createPurchaseDueByParams(array $params)
 * @method createPurchaseAdvanceByParams(array $params)
 */
class Purchase {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建采购需求
     *
     * @support  int $purchasesId 采购需求id [ require true ]
     * @support  int $staffId 申请人工号 [ require true ]
     * @support  int $creatorId 创建人 [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $status 状态 [ require true ]
     * @support  string $type 采购类型 
     * @support  int $nsType NS 采购类型 
     * @support  string $remark remark 
     * @support  array $materialSkus 采购明细 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPurchase () {
        return self::getClass()->createPurchase();
    }

    /**
     * 修改采购需求状态
     *
     * @support  int $purchasesId 采购需求id [ require true ]
     * @support  string $status 订单状态 [ require true ]
     * @support  string $processInstanceId 钉钉审批实例id 
     * @support  string $approveAt 审批通过时间 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changePurchaseStatus () {
        return self::getClass()->changePurchaseStatus();
    }

    /**
     * 创建采购订单
     *
     * @support  string $orderNo 采购订单号 [ require true ]
     * @support  int $supplierId 供应商ID [Original type uint] [ require true ]
     * @support  int $createBy 创建人 [Original type uint] [ require true ]
     * @support  string $createdAt 创建时间 [ require true ]
     * @support  string $remarks 备注 
     * @support  string $orderType 采购类型 [ require true ]
     * @support  array $orderItems 采购明细 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPurchaseOrder () {
        return self::getClass()->createPurchaseOrder();
    }

    /**
     * 创建应付账单
     *
     * @support  string $dueNo 应付账单号 [ require true ]
     * @support  int $createBy 创建人 [Original type uint] [ require true ]
     * @support  string $createdAt 创建时间 [ require true ]
     * @support  int $orderId 供应商ID [Original type uint] [ require true ]
     * @support  int $supplierId 供应商ID [Original type uint] [ require true ]
     * @support  int $supplierBankId 供应商账户ID [Original type uint] [ require true ]
     * @support  string $invoiceNumber 发票号 
     * @support  float $totalMoney 总金额 [Original type double] [ require true ]
     * @support  float $prepaidMoney 预付金额 [Original type double] [ require true ]
     * @support  float $paidMoney 实付金额 [Original type double] [ require true ]
     * @support  float $exceptTaxMoney 不含税金额 [Original type double] [ require true ]
     * @support  float $taxMoney 税额 [Original type double] [ require true ]
     * @support  array $dueItems 明细 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPurchaseDue () {
        return self::getClass()->createPurchaseDue();
    }

    /**
     * 创建预付款单
     *
     * @support  string $advanceNo 预付款单号 [ require true ]
     * @support  string $createdAt 创建时间 [ require true ]
     * @support  int $orderId 供应商ID [Original type uint] [ require true ]
     * @support  int $createBy 创建人 [Original type uint] [ require true ]
     * @support  int $supplierId 供应商ID [Original type uint] [ require true ]
     * @support  int $supplierBankId 供应商账户ID [Original type uint] [ require true ]
     * @support  float $prepaidMoney 预付金额 [Original type double] [ require true ]
     * @support  string $remarks 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPurchaseAdvance () {
        return self::getClass()->createPurchaseAdvance();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectEbs', 'Erp\Purchase');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectEbs', 'Erp\Purchase');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}