<?php
namespace Mainto\Bridge\Invokes\ProjectEbs\Organization;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method syncBeisenDepartmentByParams(array $params)
 * @method syncGaiaDepartmentByParams(array $params)
 */
class Department {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 同步北森部门
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncBeisenDepartment () {
        return self::getClass()->syncBeisenDepartment();
    }

    /**
     * 同步给盖雅组织信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncGaiaDepartment () {
        return self::getClass()->syncGaiaDepartment();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectEbs', 'Organization\Department');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectEbs', 'Organization\Department');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}