<?php
namespace Mainto\Bridge\Invokes\ProjectEbs\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createStockOrderByParams(array $params)
 * @method createStockTransferByParams(array $params)
 * @method stockInByParams(array $params)
 * @method createAllocationByParams(array $params)
 * @method createReceiveByParams(array $params)
 */
class Stock {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建库存调整单
     *
     * @support  int $stockRecordId 库存记录id [ require true ]
     * @support  int $materialSkuId 物料sku_id [ require true ]
     * @support  int $locType 目前所属仓库 [ require true ]
     * @support  int $detailId 采购明细id 
     * @support  int $count 操作数量 [ require true ]
     * @support  int $staffId 操作人 ID [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $type 库存变化类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createStockOrder () {
        return self::getClass()->createStockOrder();
    }

    /**
     * 创建库存调拨单
     *
     * @support  int $stockRecordId 库存记录id [ require true ]
     * @support  int $materialSkuId 物料sku_id [ require true ]
     * @support  int $fromLocType 以前所属仓库 [ require true ]
     * @support  int $toLocType 目前所属仓库 [ require true ]
     * @support  int $detailId 采购明细id 
     * @support  int $count 操作数量 [ require true ]
     * @support  int $staffId 操作人 ID [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $type 库存变化类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createStockTransfer () {
        return self::getClass()->createStockTransfer();
    }

    /**
     * 入库通知 NS
     *
     * @support  int $stockRecordId 库存记录id [ require true ]
     * @support  int $materialSkuId 物料sku_id [ require true ]
     * @support  int $locType 所属仓库 [ require true ]
     * @support  int $detailId 采购明细id 
     * @support  int $count 操作数量 [ require true ]
     * @support  int $staffId 操作人 ID [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $type 库存变化类型 [ require true ]
     * @support  string $remark 备注 
     * @support  string $stockRecordStatus 库存记录状态 
     * @support  string $materialSkuStatus 采购明细状态 
     * @support  int $purchaseId 采购 ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function stockIn () {
        return self::getClass()->stockIn();
    }

    /**
     * 创建库存转移订单
     *
     * @support  string $allocationNo 库存转移单号 [ require true ]
     * @support  string $createdAt 创建时间 [ require true ]
     * @support  string $type 单据类型 [ require true ]
     * @support  int $fromStoreId 发货门店 [Original type uint] [ require true ]
     * @support  int $toStoreId 收货门店 [Original type uint] [ require true ]
     * @support  int $createBy 创建人 [Original type uint] [ require true ]
     * @support  string $remarks 备注 
     * @support  string $allocationItems 关联记录 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createAllocation () {
        return self::getClass()->createAllocation();
    }

    /**
     * 创建入库单
     *
     * @support  string $receiveNo 收货单号 [ require true ]
     * @support  string $relatedType 单据类型 [ require true ]
     * @support  string $relatedId 关联单号 [ require true ]
     * @support  string $createdAt 创建时间 [ require true ]
     * @support  string $remarks 备注 
     * @support  int $receiveBy 收货人 [Original type uint] [ require true ]
     * @support  string $receiveItems 关联记录 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createReceive () {
        return self::getClass()->createReceive();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectEbs', 'Erp\Stock');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectEbs', 'Erp\Stock');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}