<?php
namespace Mainto\Bridge\Invokes\ProjectEbs\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createPurchaseByParams(array $params)
 * @method changePurchaseStatusByParams(array $params)
 */
class Purchase {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建采购需求
     *
     * @support  int $purchasesId 采购需求id [ require true ]
     * @support  int $staffId 申请人工号 [ require true ]
     * @support  int $creatorId 创建人 [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $status 状态 [ require true ]
     * @support  string $type 采购类型 
     * @support  int $nsType NS 采购类型 
     * @support  string $remark remark 
     * @support  array $materialSkus 采购明细 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPurchase () {
        return self::getClass()->createPurchase();
    }

    /**
     * 修改采购需求状态
     *
     * @support  int $purchasesId 采购需求id [ require true ]
     * @support  string $status 订单状态 [ require true ]
     * @support  string $processInstanceId 钉钉审批实例id 
     * @support  string $approveAt 审批通过时间 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changePurchaseStatus () {
        return self::getClass()->changePurchaseStatus();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectEbs', 'Erp\Purchase');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectEbs', 'Erp\Purchase');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}