<?php
namespace Mainto\Bridge\Invokes\ProjectEbs\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method syncHeadquartersStockByParams(array $params)
 * @method createStockOrderByParams(array $params)
 * @method createStockTransferByParams(array $params)
 * @method stockInByParams(array $params)
 */
class Stock {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 定时任务(同步总部库存)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncHeadquartersStock () {
        return self::getClass()->syncHeadquartersStock();
    }

    /**
     * 创建库存调整单
     *
     * @support  int $stockRecordId 库存记录id [ require true ]
     * @support  int $materialSkuId 物料sku_id [ require true ]
     * @support  int $locType 目前所属仓库 [ require true ]
     * @support  int $detailId 采购明细id 
     * @support  int $count 操作数量 [ require true ]
     * @support  int $staffId 操作人 ID [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $type 库存变化类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createStockOrder () {
        return self::getClass()->createStockOrder();
    }

    /**
     * 创建库存调拨单
     *
     * @support  int $stockRecordId 库存记录id [ require true ]
     * @support  int $materialSkuId 物料sku_id [ require true ]
     * @support  int $fromLocType 以前所属仓库 [ require true ]
     * @support  int $toLocType 目前所属仓库 [ require true ]
     * @support  int $detailId 采购明细id 
     * @support  int $count 操作数量 [ require true ]
     * @support  int $staffId 操作人 ID [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $type 库存变化类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createStockTransfer () {
        return self::getClass()->createStockTransfer();
    }

    /**
     * 入库通知 NS
     *
     * @support  int $stockRecordId 库存记录id [ require true ]
     * @support  int $materialSkuId 物料sku_id [ require true ]
     * @support  int $locType 所属仓库 [ require true ]
     * @support  int $detailId 采购明细id 
     * @support  int $count 操作数量 [ require true ]
     * @support  int $staffId 操作人 ID [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $type 库存变化类型 [ require true ]
     * @support  string $remark 备注 
     * @support  string $stockRecordStatus 库存记录状态 
     * @support  string $materialSkuStatus 采购明细状态 
     * @support  int $purchaseId 采购 ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function stockIn () {
        return self::getClass()->stockIn();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectEbs', 'Erp\Stock');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectEbs', 'Erp\Stock');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}