<?php
namespace Mainto\Bridge\Invokes\ProjectEbs\Organization;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createDepartmentByParams(array $params)
 * @method updateDepartmentByParams(array $params)
 * @method deleteDepartmentByParams(array $params)
 */
class Department {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增部门
     *
     * @support  int $departmentId 部门id [ require true ]
     * @support  string $name 部门名称 [ require true ]
     * @support  int $parentId 部门id [ require true ]
     * @support  int $type 部门类型 [ require true ]
     * @support  int $subjectId 主体id [ require true ]
     * @support  int $costType 费用类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createDepartment () {
        return self::getClass()->createDepartment();
    }

    /**
     * 修改部门
     *
     * @support  int $departmentId 部门id [ require true ]
     * @support  string $name 部门名称 
     * @support  int $parentId 部门id 
     * @support  int $type 部门类型 
     * @support  int $subjectId 主体id 
     * @support  int $costType 费用类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateDepartment () {
        return self::getClass()->updateDepartment();
    }

    /**
     * 删除部门
     *
     * @support  int $departmentId 部门id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteDepartment () {
        return self::getClass()->deleteDepartment();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectEbs', 'Organization\Department');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectEbs', 'Organization\Department');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}