<?php
namespace Mainto\Bridge\Invokes\ProjectEbs\Organization;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createStaffByParams(array $params)
 * @method updateStaffByParams(array $params)
 * @method updateStaffFromOaProjectByParams(array $params)
 * @method deleteStaffByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增伙伴
     *
     * @support  int $staffId 伙伴id [ require true ]
     * @support  string $name 伙伴姓名 [ require true ]
     * @support  string $nickname 伙伴昵称 
     * @support  string $phone 手机号 
     * @support  string $level 职级 
     * @support  string $entryAt 入职时间 
     * @support  int $departmentId 所属部门id 
     * @support  int $positionId 职位id 
     * @support  string $status 状态 
     * @support  string $type 员工类型 
     * @support  string $restType 休息类型 
     * @support  string $jobType 工作组 
     * @support  string $positiveAt 转正日期 
     * @support  string $leaveAt 离职日期 
     * @support  string $leaveReason 离职原因 
     * @support  string $leaveRemark 离职备注 
     * @support  array $identityInfos 个人信息集合 
     * @support  array $identityInfoAnnexes 个人信息附件集合 
     * @support  int $recorder 录入人 
     * @support  string $remark 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createStaff () {
        return self::getClass()->createStaff();
    }

    /**
     * 修改伙伴
     *
     * @support  int $staffId 伙伴id [ require true ]
     * @support  string $name 伙伴姓名 
     * @support  string $nickname 伙伴昵称 
     * @support  string $phone 手机号 
     * @support  string $level 职级 
     * @support  string $entryAt 入职时间 
     * @support  int $departmentId 所属部门id 
     * @support  int $positionId 职位id 
     * @support  string $status 状态 
     * @support  string $type 员工类型 
     * @support  string $restType 休息类型 
     * @support  string $jobType 工作组 
     * @support  string $positiveAt 转正日期 
     * @support  string $leaveAt 离职日期 
     * @support  string $leaveReason 离职原因 
     * @support  string $leaveRemark 离职备注 
     * @support  array $identityInfos 个人信息集合 
     * @support  array $identityInfoAnnexes 个人信息附件集合 
     * @support  int $recorder 录入人 
     * @support  string $remark 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateStaff () {
        return self::getClass()->updateStaff();
    }

    /**
     * 修改伙伴（OA 端）
     *
     * @support  int $staffId 伙伴id [ require true ]
     * @support  string $name 伙伴姓名 
     * @support  string $nickname 伙伴昵称 
     * @support  string $phone 手机号 
     * @support  string $level 职级 
     * @support  string $entryAt 入职时间 
     * @support  int $departmentId 所属部门id 
     * @support  int $positionId 职位id 
     * @support  string $status 状态 
     * @support  string $type 员工类型 
     * @support  string $restType 休息类型 
     * @support  string $jobType 工作组 
     * @support  string $positiveAt 转正日期 
     * @support  string $leaveAt 离职日期 
     * @support  string $leaveReason 离职原因 
     * @support  string $leaveRemark 离职备注 
     * @support  array $identityInfos 个人信息集合 
     * @support  array $identityInfoAnnexes 个人信息附件集合 
     * @support  int $recorder 录入人 
     * @support  string $remark 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateStaffFromOaProject () {
        return self::getClass()->updateStaffFromOaProject();
    }

    /**
     * 删除伙伴
     *
     * @support  int $staffId 伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteStaff () {
        return self::getClass()->deleteStaff();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectEbs', 'Organization\Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectEbs', 'Organization\Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}