<?php
namespace Mainto\Bridge\Invokes\ProjectEbs\Organization;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createPositionByParams(array $params)
 * @method updatePositionByParams(array $params)
 * @method deletePositionByParams(array $params)
 */
class Position {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增职位
     *
     * @support  int $positionId 职位id [ require true ]
     * @support  string $name 职位名称 [ require true ]
     * @support  string $desc 描述 
     * @support  string $flag 标记 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPosition () {
        return self::getClass()->createPosition();
    }

    /**
     * 修改职位
     *
     * @support  int $positionId 职位id [ require true ]
     * @support  string $name 职位名称 [ require true ]
     * @support  string $desc 描述 
     * @support  string $flag 标记 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updatePosition () {
        return self::getClass()->updatePosition();
    }

    /**
     * 删除职位
     *
     * @support  int $positionId 职位id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deletePosition () {
        return self::getClass()->deletePosition();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectEbs', 'Organization\Position');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectEbs', 'Organization\Position');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}