<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\GeeTest;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method registerByParams(array $params)
 * @method validateByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\GeeTest\Cmd\GeeTestValidateCmd $params)
 */
class GeeTest {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 极验初始化验证
     *
     * @support  string $clientType 客户端类型 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\GeeTest\DTO\GeeTestRegisterResultDTO
     */
    public static function register () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->register([
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\GeeTest\DTO\GeeTestRegisterResultDTO"
        );
    }

    /**
     * 极验二次验证
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\GeeTest\Cmd\GeeTestValidateCmd $geeTestValidateCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\GeeTest\DTO\GeeTestValidateResultDTO
     */
    public static function validate (\Mainto\Bridge\Structs\ProjectCrm\Mobile\GeeTest\Cmd\GeeTestValidateCmd $geeTestValidateCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->validate($geeTestValidateCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\GeeTest\DTO\GeeTestValidateResultDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\GeeTest\GeeTest');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\GeeTest\GeeTest');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}