<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getActivityInfoByParams(array $params)
 * @method canInitiateActivityByParams(array $params)
 * @method canAcceptInvitationByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\AcceptInvitationCmd $params)
 * @method acceptInvitationByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\AcceptInvitationCmd $params)
 * @method getBoundRelationInfoByParams(array $params)
 * @method punchInByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\PunchInCmd $params)
 * @method applyPunchInByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\ApplyPunchInCmd $params)
 * @method getCalendarInfoByParams(array $params)
 * @method updateMomentStatusByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\UpdateMomentStatusCmd $params)
 * @method getMomentListByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\MomentListCmd $params)
 * @method likeMomentByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\LikeMomentCmd $params)
 * @method dislikeMomentByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\LikeMomentCmd $params)
 * @method getMomentByPunchDateByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\GetMomentByPunchDateCmd $params)
 * @method isFirstPunchedByParams(array $params)
 * @method isExistsMomentsInSquareByParams(array $params)
 * @method getPunchInResultsByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\PunchInResultCmd $params)
 * @method notifyBindSuccessByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\NotifyBindSuccessCmd $params)
 */
class CourtActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取告白季活动信息
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\ActivityInfoDTO
     */
    public static function getActivityInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getActivityInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\ActivityInfoDTO"
        );
    }

    /**
     * 校验发起人是否能发起活动
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function canInitiateActivity () {
        return self::getClass()->canInitiateActivity();
    }

    /**
     * 校验受邀人是否可以与发起人绑定
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\AcceptInvitationCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\AcceptInvitationCheckResultDTO
     */
    public static function canAcceptInvitation (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\AcceptInvitationCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->canAcceptInvitation($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\AcceptInvitationCheckResultDTO"
        );
    }


    /**
     * 受邀人接受发起人邀请
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\AcceptInvitationCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function acceptInvitation (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\AcceptInvitationCmd $cmd) {
        return self::getClass()->acceptInvitation($cmd);
    }


    /**
     * 获取当前用户的绑定信息
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\BoundRelationInfoDTO
     */
    public static function getBoundRelationInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getBoundRelationInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\BoundRelationInfoDTO"
        );
    }

    /**
     * 活动打卡
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\PunchInCmd $cmd
     * @throws  \Exception
     * @return  int[]
     */
    public static function punchIn (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\PunchInCmd $cmd) {
        return self::getClass()->punchIn($cmd);
    }


    /**
     * 活动补卡
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\ApplyPunchInCmd $cmd
     * @throws  \Exception
     * @return  int[]
     */
    public static function applyPunchIn (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\ApplyPunchInCmd $cmd) {
        return self::getClass()->applyPunchIn($cmd);
    }


    /**
     * 获取当前用户打卡信息
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\CalendarInfoDTO
     */
    public static function getCalendarInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCalendarInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\CalendarInfoDTO"
        );
    }

    /**
     * 更新朋友圈状态
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\UpdateMomentStatusCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateMomentStatus (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\UpdateMomentStatusCmd $cmd) {
        return self::getClass()->updateMomentStatus($cmd);
    }


    /**
     * 获取朋友圈列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\MomentListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\MomentListDTO
     */
    public static function getMomentList (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\MomentListCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMomentList($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\MomentListDTO"
        );
    }


    /**
     * 点赞朋友圈
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\LikeMomentCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function likeMoment (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\LikeMomentCmd $cmd) {
        return self::getClass()->likeMoment($cmd);
    }


    /**
     * 取消赞朋友圈
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\LikeMomentCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function dislikeMoment (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\LikeMomentCmd $cmd) {
        return self::getClass()->dislikeMoment($cmd);
    }


    /**
     * 根据打卡日期获取朋友圈信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\GetMomentByPunchDateCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\MomentDetailDTO
     */
    public static function getMomentByPunchDate (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\GetMomentByPunchDateCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMomentByPunchDate($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\MomentDetailDTO"
        );
    }


    /**
     * 是否首次已打卡
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function isFirstPunched () {
        return self::getClass()->isFirstPunched();
    }

    /**
     * 是否有朋友圈在广场
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function isExistsMomentsInSquare () {
        return self::getClass()->isExistsMomentsInSquare();
    }

    /**
     * 获取打卡结果展示
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\PunchInResultCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\CouponShowDetailDTO[]
     */
    public static function getPunchInResults (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\PunchInResultCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPunchInResults($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\CouponShowDetailDTO[]"
        );
    }


    /**
     * 告白季用户绑定成功发送通知
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\NotifyBindSuccessCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function notifyBindSuccess (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\NotifyBindSuccessCmd $cmd) {
        return self::getClass()->notifyBindSuccess($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\Activity\CourtActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\Activity\CourtActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}