<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Manage\MessageBoard;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getMessageListByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\MessageBoard\Cmd\MessageBoardSearchCMD $params)
 * @method deleteMessageByParams(array $params)
 * @method addStarByParams(array $params)
 */
class MessageBoard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 按条件查询用户留言列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\MessageBoard\Cmd\MessageBoardSearchCMD $messageBoardSearchCMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\MessageBoard\DTO\MessageBoardListDTO
     */
    public static function getMessageList (\Mainto\Bridge\Structs\ProjectCrm\Manage\MessageBoard\Cmd\MessageBoardSearchCMD $messageBoardSearchCMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMessageList($messageBoardSearchCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\MessageBoard\DTO\MessageBoardListDTO"
        );
    }


    /**
     * 删除一条用户留言
     *
     * @support  int $messageId 留言ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteMessage () {
        return self::getClass()->deleteMessage([
        ]);
    }

    /**
     * 精选一条用户留言
     *
     * @support  int $messageId 留言ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addStar () {
        return self::getClass()->addStar([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Manage\MessageBoard\MessageBoard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Manage\MessageBoard\MessageBoard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}