<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Auth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\Role\Cmd\RoleListCmd $params)
 * @method allByParams(array $params)
 * @method createByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\Role\Cmd\RoleCreateCmd $params)
 * @method detailByParams(array $params)
 * @method updateByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\Role\Cmd\RoleUpdateCmd $params)
 * @method deleteByParams(array $params)
 */
class Role {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取角色列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\Role\Cmd\RoleListCmd $roleListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\Role\DTO\RoleListDTO
     */
    public static function list (\Mainto\Bridge\Structs\ProjectCrm\Manage\Role\Cmd\RoleListCmd $roleListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($roleListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Role\DTO\RoleListDTO"
        );
    }


    /**
     * 获取角色列表
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\Role\DTO\RoleListItemDTO[]
     */
    public static function all () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->all(),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Role\DTO\RoleListItemDTO[]"
        );
    }

    /**
     * 创建角色
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\Role\Cmd\RoleCreateCmd $roleCreateCmd
     * @throws  \Exception
     * @return  int
     */
    public static function create (\Mainto\Bridge\Structs\ProjectCrm\Manage\Role\Cmd\RoleCreateCmd $roleCreateCmd) {
        return self::getClass()->create($roleCreateCmd);
    }


    /**
     * 角色信息
     *
     * @param  int $role_id 角色id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\Role\DTO\RoleDetailDTO
     */
    public static function detail (int $role_id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "role_id" => $role_id,
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Role\DTO\RoleDetailDTO"
        );
    }

    /**
     * 设置角色权限
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\Role\Cmd\RoleUpdateCmd $roleUpdateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function update (\Mainto\Bridge\Structs\ProjectCrm\Manage\Role\Cmd\RoleUpdateCmd $roleUpdateCmd) {
        return self::getClass()->update($roleUpdateCmd);
    }


    /**
     * 删除角色
     *
     * @param  int $role_id 角色id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $role_id) {
        return self::getClass()->delete([
            "role_id" => $role_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Auth\Role');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Auth\Role');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}