<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Manage\LimitedTimeBuy;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method updateShowStateByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\LimitedTimeBuy\CMD\GoodsDisplayStateCMD $params)
 * @method updateSpeakStateByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\LimitedTimeBuy\CMD\GoodsSpeakStateCMD $params)
 * @method updateGoodsFeatureByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\LimitedTimeBuy\CMD\GoodsFeatureCMD $params)
 * @method getGoodsMarketingListByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\LimitedTimeBuy\CMD\GoodsSearchCMD $params)
 */
class GoodsMarketing {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 修改商品的显示状态
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\LimitedTimeBuy\CMD\GoodsDisplayStateCMD $CMD
     * @throws  \Exception
     * @return  bool
     */
    public static function updateShowState (\Mainto\Bridge\Structs\ProjectCrm\Manage\LimitedTimeBuy\CMD\GoodsDisplayStateCMD $CMD) {
        return self::getClass()->updateShowState($CMD);
    }


    /**
     * 修改产品组的讲解状态
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\LimitedTimeBuy\CMD\GoodsSpeakStateCMD $CMD
     * @throws  \Exception
     * @return  bool
     */
    public static function updateSpeakState (\Mainto\Bridge\Structs\ProjectCrm\Manage\LimitedTimeBuy\CMD\GoodsSpeakStateCMD $CMD) {
        return self::getClass()->updateSpeakState($CMD);
    }


    /**
     * 修改商品卖点
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\LimitedTimeBuy\CMD\GoodsFeatureCMD $CMD
     * @throws  \Exception
     * @return  bool
     */
    public static function updateGoodsFeature (\Mainto\Bridge\Structs\ProjectCrm\Manage\LimitedTimeBuy\CMD\GoodsFeatureCMD $CMD) {
        return self::getClass()->updateGoodsFeature($CMD);
    }


    /**
     * 查询商品列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\LimitedTimeBuy\CMD\GoodsSearchCMD $goodsSearchCMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\LimitedTimeBuy\DTO\GoodsMarketingListDTO
     */
    public static function getGoodsMarketingList (\Mainto\Bridge\Structs\ProjectCrm\Manage\LimitedTimeBuy\CMD\GoodsSearchCMD $goodsSearchCMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getGoodsMarketingList($goodsSearchCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\LimitedTimeBuy\DTO\GoodsMarketingListDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Manage\LimitedTimeBuy\GoodsMarketing');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Manage\LimitedTimeBuy\GoodsMarketing');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}