<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Manage\Milestone;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneCreateCmd $params)
 * @method updateByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneUpdateCmd $params)
 * @method updateStateByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneUpdateStateCmd $params)
 * @method infoByParams(array $params)
 * @method allByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneAllCmd $params)
 */
class Milestone {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建里程碑
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneCreateCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\DTO\MilestoneCreateDTO
     */
    public static function create (\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneCreateCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->create($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\DTO\MilestoneCreateDTO"
        );
    }


    /**
     * 编辑里程碑
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneUpdateCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function update (\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneUpdateCmd $cmd) {
        return self::getClass()->update($cmd);
    }


    /**
     * 里程碑上下架
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneUpdateStateCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateState (\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneUpdateStateCmd $cmd) {
        return self::getClass()->updateState($cmd);
    }


    /**
     * 里程碑详情
     *
     * @param  int $id 里程碑id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\DTO\MilestoneInfoDTO
     */
    public static function info (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->info([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\DTO\MilestoneInfoDTO"
        );
    }

    /**
     * 获取全部里程碑数据
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneAllCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\DTO\MilestoneInfoDTO[]
     */
    public static function all (\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneAllCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->all($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\DTO\MilestoneInfoDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Manage\Milestone\Milestone');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Manage\Milestone\Milestone');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}