<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\FairyTaleActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getActivityInfoByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetActivityInfoCMD $params)
 * @method getVenueInfoByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetVenueInfoCMD $params)
 * @method openClueByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\OpenClueCMD $params)
 * @method getUserClueProgressByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetUserClueProgressCMD $params)
 * @method answerQuestionByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\AnswerQuestionCMD $params)
 * @method getFragmentByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetFragmentCMD $params)
 * @method createShareRecordByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\CreateShareRecordCMD $params)
 * @method getShareRecordByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetShareRecordCMD $params)
 * @method sendFragmentByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\SendFragmentCMD $params)
 * @method receiveFragmentByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\ReceiveFragmentCMD $params)
 * @method getUserCluesFragmentByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetUserCluesFragmentCMD $params)
 * @method getUserRepeatCluesByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetUserRepeatCluesCMD $params)
 * @method getUserOpenedCluesByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetUserOpenedCluesCMD $params)
 * @method submitCommandByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\SubmitCommandCMD $params)
 * @method getTodayCommandByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetTodayCommandCMD $params)
 * @method getFragmentActivityStatusByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetFragmentActivityStatusCMD $params)
 * @method getCollectAllRewardInfoByParams(array $params)
 * @method getCurrentClueRewardInfoByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetCurrentClueRewardInfoCMD $params)
 * @method touchFragmentByParams(array $params)
 * @method updateUserFragmentTouchStatusByParams(array $params)
 * @method getSponsorFragmentByParams(array $params)
 * @method confirmFragmentTouchByParams(array $params)
 * @method getFragmentTouchResultByParams(array $params)
 * @method getUserGainEarlyBirdInfoByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetUserGainEarlyBirdInfoCMD $params)
 */
class FairyTaleActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取活动信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetActivityInfoCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\ActivityInfoDTO
     */
    public static function getActivityInfo (\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetActivityInfoCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getActivityInfo($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\ActivityInfoDTO"
        );
    }


    /**
     * 获取指定会场信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetVenueInfoCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\VenueInfoItemDTO
     */
    public static function getVenueInfo (\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetVenueInfoCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getVenueInfo($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\VenueInfoItemDTO"
        );
    }


    /**
     * 开启线索
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\OpenClueCMD $cmd
     * @throws  \Exception
     * @return  int
     */
    public static function openClue (\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\OpenClueCMD $cmd) {
        return self::getClass()->openClue($cmd);
    }


    /**
     * 获取用户当前线索进度
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetUserClueProgressCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\UserClueProgressDTO
     */
    public static function getUserClueProgress (\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetUserClueProgressCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserClueProgress($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\UserClueProgressDTO"
        );
    }


    /**
     * 回答当前线索问题
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\AnswerQuestionCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\AnswerQuestionResultDTO
     */
    public static function answerQuestion (\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\AnswerQuestionCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->answerQuestion($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\AnswerQuestionResultDTO"
        );
    }


    /**
     * 获取指定的碎片信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetFragmentCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\FragmentInfoDTO
     */
    public static function getFragment (\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetFragmentCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getFragment($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\FragmentInfoDTO"
        );
    }


    /**
     * 创建分享记录
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\CreateShareRecordCMD $cmd
     * @throws  \Exception
     * @return  int
     */
    public static function createShareRecord (\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\CreateShareRecordCMD $cmd) {
        return self::getClass()->createShareRecord($cmd);
    }


    /**
     * 获取分享记录详情
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetShareRecordCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\ShareRecordDetailDTO
     */
    public static function getShareRecord (\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetShareRecordCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getShareRecord($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\ShareRecordDetailDTO"
        );
    }


    /**
     * 同意索要线索碎片
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\SendFragmentCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function sendFragment (\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\SendFragmentCMD $cmd) {
        return self::getClass()->sendFragment($cmd);
    }


    /**
     * 同意领取线索碎片
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\ReceiveFragmentCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function receiveFragment (\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\ReceiveFragmentCMD $cmd) {
        return self::getClass()->receiveFragment($cmd);
    }


    /**
     * 获取用户的线索碎片信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetUserCluesFragmentCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\UserCluesFragmentDTO
     */
    public static function getUserCluesFragment (\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetUserCluesFragmentCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserCluesFragment($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\UserCluesFragmentDTO"
        );
    }


    /**
     * 获取用户所有重复的线索
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetUserRepeatCluesCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\UserRepeatCluesItemDTO[]
     */
    public static function getUserRepeatClues (\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetUserRepeatCluesCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserRepeatClues($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\UserRepeatCluesItemDTO[]"
        );
    }


    /**
     * 获取用户已开启的线索信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetUserOpenedCluesCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\UserOpenedCluesDTO
     */
    public static function getUserOpenedClues (\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetUserOpenedCluesCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserOpenedClues($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\UserOpenedCluesDTO"
        );
    }


    /**
     * 提交口令
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\SubmitCommandCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\SubmitCommandResultDTO
     */
    public static function submitCommand (\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\SubmitCommandCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->submitCommand($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\SubmitCommandResultDTO"
        );
    }


    /**
     * 获取今日口令
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetTodayCommandCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\TodayCommandDTO
     */
    public static function getTodayCommand (\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetTodayCommandCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getTodayCommand($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\TodayCommandDTO"
        );
    }


    /**
     * 获取用户碎片活动状态--答题以及碰一碰
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetFragmentActivityStatusCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\FragmentActivityStatusDTO
     */
    public static function getFragmentActivityStatus (\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetFragmentActivityStatusCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getFragmentActivityStatus($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\FragmentActivityStatusDTO"
        );
    }


    /**
     * 获取线索集齐奖励信息
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\CollectAllRewardInfoDTO
     */
    public static function getCollectAllRewardInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCollectAllRewardInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\CollectAllRewardInfoDTO"
        );
    }

    /**
     * 获取当前线索奖励信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetCurrentClueRewardInfoCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\CollectAllRewardInfoDTO
     */
    public static function getCurrentClueRewardInfo (\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetCurrentClueRewardInfoCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCurrentClueRewardInfo($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\CollectAllRewardInfoDTO"
        );
    }


    /**
     * 碎片碰一碰
     *
     * @param  int $inviterFragmentId 邀请人碎片ID [ require true ]
     * @param  int $invitedFragmentId 受邀人碎片ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\FragmentTouchResultDTO
     */
    public static function touchFragment (int $inviterFragmentId, int $invitedFragmentId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->touchFragment([
                            "inviterFragmentId" => $inviterFragmentId,
                            "invitedFragmentId" => $invitedFragmentId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\FragmentTouchResultDTO"
        );
    }

    /**
     * 更新用户碎片碰一碰状态
     *
     * @param  int $clueId 线索ID [ require true ]
     * @param  int $fragmentId 碎片ID [ require true ]
     * @param  int $isLocked 1=开启，0=取消 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateUserFragmentTouchStatus (int $clueId, int $fragmentId, int $isLocked) {
        return self::getClass()->updateUserFragmentTouchStatus([
            "clueId" => $clueId,
            "fragmentId" => $fragmentId,
            "isLocked" => $isLocked,
        ]);
    }

    /**
     * 获取发起人碎片信息
     *
     * @param  int $sponsorId 发起人ID [ require true ]
     * @param  int $clueId 线索ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\SponsorFragmentDTO
     */
    public static function getSponsorFragment (int $sponsorId, int $clueId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getSponsorFragment([
                            "sponsorId" => $sponsorId,
                            "clueId" => $clueId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\SponsorFragmentDTO"
        );
    }

    /**
     * 确认碰一碰线索碎片
     *
     * @param  int $sponsorFragmentId 发起人碎片ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\ConfirmTouchFragmentDTO
     */
    public static function confirmFragmentTouch (int $sponsorFragmentId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->confirmFragmentTouch([
                            "sponsorFragmentId" => $sponsorFragmentId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\ConfirmTouchFragmentDTO"
        );
    }

    /**
     * 获取碎片碰一碰结果
     *
     * @param  int $clueId 线索ID [ require true ]
     * @support  int $sponsorId 发起人UID [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\FragmentTouchResultDTO
     */
    public static function getFragmentTouchResult (int $clueId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getFragmentTouchResult([
                            "clueId" => $clueId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\FragmentTouchResultDTO"
        );
    }

    /**
     * 获取用户获得的早鸟优惠信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetUserGainEarlyBirdInfoCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\EarlyBirdProductDTO[]
     */
    public static function getUserGainEarlyBirdInfo (\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetUserGainEarlyBirdInfoCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserGainEarlyBirdInfo($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\EarlyBirdProductDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\FairyTaleActivity\FairyTaleActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\FairyTaleActivity\FairyTaleActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}