<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\WechatWork;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getMomentSettingByParams(array $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\WechatWorkMoment\Cmd\MomentListCmd $params)
 * @method getMomentByParams(array $params)
 */
class Moment {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取朋友圈页面设置
     *
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMomentSetting () {
        return self::getClass()->getMomentSetting([
        ]);
    }

    /**
     * 获取企业微信朋友圈列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\WechatWorkMoment\Cmd\MomentListCmd $momentListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\WechatWorkMoment\DTO\MomentListDTO
     */
    public static function list (\Mainto\Bridge\Structs\ProjectCrm\Mobile\WechatWorkMoment\Cmd\MomentListCmd $momentListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($momentListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\WechatWorkMoment\DTO\MomentListDTO"
        );
    }


    /**
     * 获取单条企业微信朋友圈
     *
     * @support  int $id 朋友圈id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\WechatWorkMoment\DTO\MomentDetailDTO
     */
    public static function getMoment () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMoment([
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\WechatWorkMoment\DTO\MomentDetailDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'WechatWork\Moment');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'WechatWork\Moment');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}