<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method clueCollectNotifyByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\ClueCollectNotifyCMD $params)
 */
class FairyTaleActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订阅的角色集齐碎片
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\ClueCollectNotifyCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function clueCollectNotify (\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\ClueCollectNotifyCMD $cmd) {
        return self::getClass()->clueCollectNotify($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'MessageHook\FairyTaleActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'MessageHook\FairyTaleActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}