<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\FamilyMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPageSettingByParams(array $params)
 * @method getMemberStatusByParams(array $params)
 */
class FamilyMember {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取页面配置信息
     *
     * @support  string $brand 品牌 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FamilyMember\DTO\PageSettingDTO
     */
    public static function getPageSetting () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPageSetting([
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\FamilyMember\DTO\PageSettingDTO"
        );
    }

    /**
     * 获取家庭会员状态
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FamilyMember\DTO\MemberStatusDetailDTO
     */
    public static function getMemberStatus () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMemberStatus(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\FamilyMember\DTO\MemberStatusDetailDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\FamilyMember\FamilyMember');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\FamilyMember\FamilyMember');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}