<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\FairyTaleActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getActivityInfoByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetActivityInfoCMD $params)
 * @method getVenueInfoByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetVenueInfoCMD $params)
 * @method openClueByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\OpenClueCMD $params)
 */
class FairyTaleActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取活动信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetActivityInfoCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\ActivityInfoDTO
     */
    public static function getActivityInfo (\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetActivityInfoCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getActivityInfo($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\ActivityInfoDTO"
        );
    }


    /**
     * 获取指定会场信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetVenueInfoCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\VenueInfoItemDTO
     */
    public static function getVenueInfo (\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\GetVenueInfoCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getVenueInfo($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\DTO\VenueInfoItemDTO"
        );
    }


    /**
     * 开启线索
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\OpenClueCMD $cmd
     * @throws  \Exception
     * @return  int
     */
    public static function openClue (\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\OpenClueCMD $cmd) {
        return self::getClass()->openClue($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\FairyTaleActivity\FairyTaleActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\FairyTaleActivity\FairyTaleActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}