<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\GraduationGiftPackageActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method isReceivedByParams(array $params)
 * @method giftPackageCouponsByParams(array $params)
 * @method receiveByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\GraduationGiftPackageActivity\Cmd\GraduationGiftPackageReceiveCmd $params)
 */
class GraduationGiftPackage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 是否领取过毕业大礼包
     *
     * @param  int $userId 会员id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\GraduationGiftPackageActivity\DTO\GraduationGiftPackageIsReceiveDTO
     */
    public static function isReceived (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->isReceived([
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\GraduationGiftPackageActivity\DTO\GraduationGiftPackageIsReceiveDTO"
        );
    }

    /**
     * 获取毕业季大礼包列表
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\GraduationGiftPackageActivity\DTO\GraduationGiftPackageCouponsDTO
     */
    public static function giftPackageCoupons () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->giftPackageCoupons(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\GraduationGiftPackageActivity\DTO\GraduationGiftPackageCouponsDTO"
        );
    }

    /**
     * 领取毕业大礼包
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\GraduationGiftPackageActivity\Cmd\GraduationGiftPackageReceiveCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function receive (\Mainto\Bridge\Structs\ProjectCrm\Mobile\GraduationGiftPackageActivity\Cmd\GraduationGiftPackageReceiveCmd $cmd) {
        return self::getClass()->receive($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\GraduationGiftPackageActivity\GraduationGiftPackage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\GraduationGiftPackageActivity\GraduationGiftPackage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}