<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method updateOverExpiredAtMembersByParams(array $params)
 * @method updateOverLockExpiredAtMembersByParams(array $params)
 */
class FamilyMemberCron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 每隔2分钟更新100条过期的家庭会员
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function updateOverExpiredAtMembers () {
        return self::getClass()->updateOverExpiredAtMembers();
    }

    /**
     * 每隔2分钟更新100条过期的锁定中的家庭会员
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function updateOverLockExpiredAtMembers () {
        return self::getClass()->updateOverLockExpiredAtMembers();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Cron\FamilyMemberCron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Cron\FamilyMemberCron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}