<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method becomeFamilyMemberByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\FamilyMember\CMD\CreateFamilyMemberCMD $params)
 */
class FamilyMember {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 成为家庭会员
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FamilyMember\CMD\CreateFamilyMemberCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function becomeFamilyMember (\Mainto\Bridge\Structs\ProjectCrm\Mobile\FamilyMember\CMD\CreateFamilyMemberCMD $cmd) {
        return self::getClass()->becomeFamilyMember($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'MessageHook\FamilyMember');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'MessageHook\FamilyMember');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}