<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method productUpdateEventByParams(array $params)
 * @method productBlackStoreChangeEventByParams(array $params)
 * @method loadCityPriceToCacheEventByParams(array $params)
 */
class LimitedTimeBuyEvent {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 产品库更新事件
     *
     * @param  int $productId 产品ID [ require true ]
     * @param  string $type 类型：setStatus、setCHidden、update [ require true ]
     * @throws  \Exception
     * @return  void
     */
    public static function productUpdateEvent (int $productId, string $type) {
        return self::getClass()->productUpdateEvent([
            "productId" => $productId,
            "type" => $type,
        ]);
    }

    /**
     * 产品禁用门店事件
     *
     * @param  array $productIds 产品Ids [ require true ]
     * @param  array $storeIds 门店Ids [ require true ]
     * @throws  \Exception
     * @return  void
     */
    public static function productBlackStoreChangeEvent (array $productIds, array $storeIds) {
        return self::getClass()->productBlackStoreChangeEvent([
            "productIds" => $productIds,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 加载限时购活动城市价格事件
     *
     * @param  int $activityId 活动ID [ require true ]
     * @throws  \Exception
     * @return  void
     */
    public static function loadCityPriceToCacheEvent (int $activityId) {
        return self::getClass()->loadCityPriceToCacheEvent([
            "activityId" => $activityId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'MessageHook\LimitedTimeBuyEvent');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'MessageHook\LimitedTimeBuyEvent');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}