<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method receiveStatusByParams(array $params)
 * @method receiveCouponByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\Member\Cmd\BirthDayCouponReceiveCmd $params)
 * @method birthDayChangeReceiveCouponByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\Member\Cmd\BirthDayChangeReceiveCouponCmd $params)
 * @method reissueBirthDayCouponByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\Member\Cmd\BirthDayCouponReissueCmd $params)
 */
class BirthDayCoupon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 会员生日优惠券领取状态
     *
     * @support  int $userId 会员id [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function receiveStatus () {
        return self::getClass()->receiveStatus([
        ]);
    }

    /**
     * 领取生日优惠券
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\Member\Cmd\BirthDayCouponReceiveCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function receiveCoupon (\Mainto\Bridge\Structs\ProjectCrm\Mobile\Member\Cmd\BirthDayCouponReceiveCmd $cmd) {
        return self::getClass()->receiveCoupon($cmd);
    }


    /**
     * 发送生日礼遇优惠券
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\Member\Cmd\BirthDayChangeReceiveCouponCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function birthDayChangeReceiveCoupon (\Mainto\Bridge\Structs\ProjectCrm\Mobile\Member\Cmd\BirthDayChangeReceiveCouponCmd $cmd) {
        return self::getClass()->birthDayChangeReceiveCoupon($cmd);
    }


    /**
     * 补发生日券
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\Member\Cmd\BirthDayCouponReissueCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function reissueBirthDayCoupon (\Mainto\Bridge\Structs\ProjectCrm\Mobile\Member\Cmd\BirthDayCouponReissueCmd $cmd) {
        return self::getClass()->reissueBirthDayCoupon($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\Member\BirthDayCoupon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\Member\BirthDayCoupon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}