<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method createTemplateByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCardTemplate\Cmd\TemplateCreateCmd $params)
 * @method updateTemplateByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCardTemplate\Cmd\TemplateUpdateCmd $params)
 * @method modifyTemplateStateByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCardTemplate\Cmd\TemplateStateModifyCmd $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCardTemplate\Cmd\MemberCardTemplateListCmd $params)
 */
class MemberCardTemplateManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取会员卡模板详情
     *
     * @support  int $template_id 会员卡模板id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCardTemplate\DTO\MemberCardTemplateDetailDTO
     */
    public static function detail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCardTemplate\DTO\MemberCardTemplateDetailDTO"
        );
    }

    /**
     * 创建会员卡模板
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCardTemplate\Cmd\TemplateCreateCmd $templateCreateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createTemplate (\Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCardTemplate\Cmd\TemplateCreateCmd $templateCreateCmd) {
        return self::getClass()->createTemplate($templateCreateCmd);
    }


    /**
     * 编辑会员卡模板
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCardTemplate\Cmd\TemplateUpdateCmd $templateUpdateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateTemplate (\Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCardTemplate\Cmd\TemplateUpdateCmd $templateUpdateCmd) {
        return self::getClass()->updateTemplate($templateUpdateCmd);
    }


    /**
     * 修改会员卡模板状态
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCardTemplate\Cmd\TemplateStateModifyCmd $templateStateModifyCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function modifyTemplateState (\Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCardTemplate\Cmd\TemplateStateModifyCmd $templateStateModifyCmd) {
        return self::getClass()->modifyTemplateState($templateStateModifyCmd);
    }


    /**
     * 获取会员卡模板列表--分页
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCardTemplate\Cmd\MemberCardTemplateListCmd $memberCardTemplateListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCardTemplate\DTO\MemberCardTemplateListDTO
     */
    public static function list (\Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCardTemplate\Cmd\MemberCardTemplateListCmd $memberCardTemplateListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($memberCardTemplateListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCardTemplate\DTO\MemberCardTemplateListDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Member\MemberCardTemplateManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Member\MemberCardTemplateManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}