<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\ReunionSeasonActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method joinActivityByParams(array $params)
 * @method isJoinedByParams(array $params)
 * @method getActivityInfoByParams(array $params)
 * @method answerQuestionByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\CMD\AnswerQuestionCMD $params)
 * @method getShareRecordDetailByParams(array $params)
 * @method getUserJoinActivityInfoByParams(array $params)
 */
class ReunionSeasonActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 开启活动
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function joinActivity () {
        return self::getClass()->joinActivity();
    }

    /**
     * 是否已开启活动
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function isJoined () {
        return self::getClass()->isJoined();
    }

    /**
     * 获取活动信息
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\DTO\ActivityInfoDTO
     */
    public static function getActivityInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getActivityInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\DTO\ActivityInfoDTO"
        );
    }

    /**
     * 用户答题
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\CMD\AnswerQuestionCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\DTO\AnswerQuestionResultDTO
     */
    public static function answerQuestion (\Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\CMD\AnswerQuestionCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->answerQuestion($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\DTO\AnswerQuestionResultDTO"
        );
    }


    /**
     * 获取分享记录详情
     *
     * @support  int $recordId 分享记录id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\DTO\ShareRecordDetailDTO
     */
    public static function getShareRecordDetail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getShareRecordDetail([
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\DTO\ShareRecordDetailDTO"
        );
    }

    /**
     * 用户参与活动详情
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\DTO\UserJoinActivityInfoDTO
     */
    public static function getUserJoinActivityInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserJoinActivityInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\DTO\UserJoinActivityInfoDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\ReunionSeasonActivity\ReunionSeasonActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\ReunionSeasonActivity\ReunionSeasonActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}