<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-11-23 13:31:48
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Auth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Role
 * @method listByParams(array $params) 获取角色列表
 * @method allByParams(array $params) 获取角色列表
 * @method createByParams(array $params) 创建角色
 * @method detailByParams(array $params) 角色信息
 * @method updateByParams(array $params) 设置角色权限
 * @method deleteByParams(array $params) 删除角色
 */
class Role {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Auth\\Role";

    /**
     * 获取角色列表
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\Role\DTO\RoleListDTO
    */
    public static function list (?\Mainto\Bridge\Structs\ProjectCrm\Manage\Role\Cmd\RoleListCmd $roleListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list($roleListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Role\DTO\RoleListDTO"
        );
    }

    /**
     * 获取角色列表
     * @return  array
    */
    public static function all () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->all(),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Role\DTO\RoleListItemDTO[]"
        );
    }

    /**
     * 创建角色
     * @return  int
    */
    public static function create (\Mainto\Bridge\Structs\ProjectCrm\Manage\Role\Cmd\RoleCreateCmd $roleCreateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($roleCreateCmd);
    }

    /**
     * 角色信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\Role\DTO\RoleDetailDTO
    */
    public static function detail (int $role_id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(["role_id" => $role_id]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Role\DTO\RoleDetailDTO"
        );
    }

    /**
     * 设置角色权限
     * @return  bool
    */
    public static function update (\Mainto\Bridge\Structs\ProjectCrm\Manage\Role\Cmd\RoleUpdateCmd $roleUpdateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update($roleUpdateCmd);
    }

    /**
     * 删除角色
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function delete (int $role_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["role_id" => $role_id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}