<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-12-05 17:58:05
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ChristmasActivity
 * @method getUserInfoByParams(array $params) 获取用户信息
 * @method pushCouponByParams(array $params) 发放优惠券
 * @method createMiniProgramQrcodeByParams(array $params) 创建小程序码
 * @method getChristmasProductFinishPhotoListByParams(array $params) 获取圣诞产品客户成片列表
 * @method pushMessageNotifyByParams(array $params) 推送消息通知
 */
class ChristmasActivity {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Activity\\ChristmasActivity";

    /**
     * 获取用户信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getUserInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserInfo();
    }

    /**
     * 发放优惠券
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function pushCoupon (int $templateId, string $userId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pushCoupon(array_merge($_params, ["templateId" => $templateId, "userId" => $userId]));
    }

    /**
     * 创建小程序码
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function createMiniProgramQrcode (string $path, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createMiniProgramQrcode(array_merge($_params, ["path" => $path]));
    }

    /**
     * 获取圣诞产品客户成片列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getChristmasProductFinishPhotoList (string $brand, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getChristmasProductFinishPhotoList(array_merge($_params, ["brand" => $brand]));
    }

    /**
     * 推送消息通知
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function pushMessageNotify (string $templateId, string $jumpUrl, string $userId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pushMessageNotify(array_merge($_params, ["templateId" => $templateId, "jumpUrl" => $jumpUrl, "userId" => $userId]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}