<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-12-14 15:14:38
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Cron
 * @method spreadPlanPushTaskByParams(array $params) 推广任务
 * @method messageTouchPushTaskByParams(array $params) 消息触达
 * @method cronTestByParams(array $params) 定时任务测试发送
 * @method pushCouponReceiveNotificationByParams(array $params) 推送优惠券领取通知
 * @method statisticsMemberCardTemplateActivatedNumByParams(array $params) 统计会员卡模板激活数量
 */
class Cron {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Cron\\Cron";

    /**
     * 推广任务
     * @return  bool
    */
    public static function spreadPlanPushTask () {
        return RpcClass::getClass(self::$serviceName, self::$className)->spreadPlanPushTask();
    }

    /**
     * 消息触达
     * @return  bool
    */
    public static function messageTouchPushTask () {
        return RpcClass::getClass(self::$serviceName, self::$className)->messageTouchPushTask();
    }

    /**
     * 定时任务测试发送
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function cronTest (string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronTest(["type" => $type]);
    }

    /**
     * 推送优惠券领取通知
     * @return  bool
    */
    public static function pushCouponReceiveNotification () {
        return RpcClass::getClass(self::$serviceName, self::$className)->pushCouponReceiveNotification();
    }

    /**
     * 统计会员卡模板激活数量
     * @return  bool
    */
    public static function statisticsMemberCardTemplateActivatedNum () {
        return RpcClass::getClass(self::$serviceName, self::$className)->statisticsMemberCardTemplateActivatedNum();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}