<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-11-24 18:53:08
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Manage\DisneyPrincessActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class DisneyPrincessActivityMessage
 * @method activitySendRewardByParams(array $params) 迪士尼公主季活动发奖
 * @method sendDmpCheckPassRewardByParams(array $params) 迪士尼公主季活动发奖--人群包奖励开奖
 * @method sendRewardByParams(array $params) 迪士尼公主季发奖
 * @method activityStartNotifyByParams(array $params) 迪士尼活动开始通知
 * @method newProductOnSaleNotifyByParams(array $params) 迪士尼公主季新品上线通知
 * @method timedDrawNotifyByParams(array $params) 迪士尼公主季开奖通知
 * @method setBlindBoxUsedByParams(array $params) 创建订单--设置盲盒状态为已使用
 * @method setBlindBoxUnUsedByParams(array $params) 订单取消解锁早鸟优惠
 * @method setBlindBoxUnUsedWhenRefundByParams(array $params) 订单退款解锁早鸟优惠
 * @method setCheckPassSucceededSortByParams(array $params) 设置人群包通过中奖序号
 */
class DisneyPrincessActivityMessage {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Manage\\DisneyPrincessActivity\\DisneyPrincessActivityMessage";

    /**
     * 迪士尼公主季活动发奖
     * @return  bool
    */
    public static function activitySendReward (\Mainto\Bridge\Structs\ProjectCrm\Manage\DisneyPrincessActivity\CMD\ActivitySendRewardCMD $activitySendRewardCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->activitySendReward($activitySendRewardCMD);
    }

    /**
     * 迪士尼公主季活动发奖--人群包奖励开奖
     * @return  bool
    */
    public static function sendDmpCheckPassReward (\Mainto\Bridge\Structs\ProjectCrm\Manage\DisneyPrincessActivity\CMD\ActivitySendRewardCMD $activitySendRewardCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendDmpCheckPassReward($activitySendRewardCMD);
    }

    /**
     * 迪士尼公主季发奖
     * @return  bool
    */
    public static function sendReward (\Mainto\Bridge\Structs\ProjectCrm\Manage\DisneyPrincessActivity\CMD\SendRewardCMD $sendRewardCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendReward($sendRewardCMD);
    }

    /**
     * 迪士尼活动开始通知
     * @return  bool
    */
    public static function activityStartNotify (\Mainto\Bridge\Structs\ProjectCrm\Manage\DisneyPrincessActivity\CMD\ActivityStartNotifyCMD $activityStartNotifyCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->activityStartNotify($activityStartNotifyCMD);
    }

    /**
     * 迪士尼公主季新品上线通知
     * @return  bool
    */
    public static function newProductOnSaleNotify (\Mainto\Bridge\Structs\ProjectCrm\Manage\DisneyPrincessActivity\CMD\NewProductOnSaleNotifyCMD $newProductOnSaleNotifyCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->newProductOnSaleNotify($newProductOnSaleNotifyCMD);
    }

    /**
     * 迪士尼公主季开奖通知
     * @return  bool
    */
    public static function timedDrawNotify (\Mainto\Bridge\Structs\ProjectCrm\Manage\DisneyPrincessActivity\CMD\TimedDrawNotifyCMD $timedDrawNotifyCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->timedDrawNotify($timedDrawNotifyCMD);
    }

    /**
     * 创建订单--设置盲盒状态为已使用
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function setBlindBoxUsed (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setBlindBoxUsed(["orderId" => $orderId]);
    }

    /**
     * 订单取消解锁早鸟优惠
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function setBlindBoxUnUsed (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setBlindBoxUnUsed(["orderId" => $orderId]);
    }

    /**
     * 订单退款解锁早鸟优惠
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function setBlindBoxUnUsedWhenRefund (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setBlindBoxUnUsedWhenRefund(["orderId" => $orderId]);
    }

    /**
     * 设置人群包通过中奖序号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function setCheckPassSucceededSort (int $activityId, int $memberId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setCheckPassSucceededSort(["activityId" => $activityId, "memberId" => $memberId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}