<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-11-28 17:56:34
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\SweetMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class SweetMember
 * @method getSweetMemberInfoByParams(array $params) 获取sweet member信息
 * @method getSweetMemberInfoBridgeByUserIdByParams(array $params) 获取sweet member信息
 * @method receiveSweetMemberByParams(array $params) 领取sweet member
 * @method getIntegralLaddersByParams(array $params) 获取sweet member梯度信息
 * @method getWithdrawCalendarByParams(array $params) 获取提现日历
 * @method listWithdrawByParams(array $params) 提现明细
 * @method withdrawIntegralByParams(array $params) 提现
 * @method submitAnniversaryByParams(array $params) 提交纪念日
 * @method submitAnniversaryBridgeByParams(array $params) 提交纪念日
 * @method getSweetMemberLayerByParams(array $params) 获取弹框行为
 * @method deleteBehaviorByParams(array $params) 删除行为
 * @method getSweetMemberSettingByParams(array $params) sweet相关配置
 */
class SweetMember {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Mobile\\SweetMember\\SweetMember";

    /**
     * 获取sweet member信息
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\SweetMember\DTO\SweetMemberInfoDTO
    */
    public static function getSweetMemberInfo (\Mainto\Bridge\Structs\ProjectCrm\Mobile\SweetMember\CMD\GetSweetMemberInfoCMD $getSweetMemberInfoCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSweetMemberInfo($getSweetMemberInfoCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\SweetMember\DTO\SweetMemberInfoDTO"
        );
    }

    /**
     * 获取sweet member信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\SweetMember\DTO\SweetMemberInfoDTO
    */
    public static function getSweetMemberInfoBridgeByUserId (int $userId, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSweetMemberInfoBridgeByUserId(array_merge($_params, ["userId" => $userId])),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\SweetMember\DTO\SweetMemberInfoDTO"
        );
    }

    /**
     * 领取sweet member
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\SweetMember\DTO\ReceiveSweetMemberDTO
    */
    public static function receiveSweetMember (\Mainto\Bridge\Structs\ProjectCrm\Mobile\SweetMember\CMD\ReceiveSweetMemberCMD $receiveSweetMemberCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->receiveSweetMember($receiveSweetMemberCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\SweetMember\DTO\ReceiveSweetMemberDTO"
        );
    }

    /**
     * 获取sweet member梯度信息
     * @return  array
    */
    public static function getIntegralLadders (\Mainto\Bridge\Structs\ProjectCrm\Mobile\SweetMember\CMD\GetIntegralLaddersCMD $getIntegralLaddersCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getIntegralLadders($getIntegralLaddersCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\SweetMember\DTO\IntegralLaddersDTO[]"
        );
    }

    /**
     * 获取提现日历
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\SweetMember\DTO\WithdrawCalendarDTO
    */
    public static function getWithdrawCalendar (\Mainto\Bridge\Structs\ProjectCrm\Mobile\SweetMember\CMD\GetWithdrawCalendarCMD $getWithdrawCalendarCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getWithdrawCalendar($getWithdrawCalendarCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\SweetMember\DTO\WithdrawCalendarDTO"
        );
    }

    /**
     * 提现明细
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\SweetMember\DTO\ListWithdrawDTO
    */
    public static function listWithdraw (\Mainto\Bridge\Structs\ProjectCrm\Mobile\SweetMember\CMD\ListWithdrawCMD $listWithdrawCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->listWithdraw($listWithdrawCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\SweetMember\DTO\ListWithdrawDTO"
        );
    }

    /**
     * 提现
     * @return  bool
    */
    public static function withdrawIntegral (\Mainto\Bridge\Structs\ProjectCrm\Mobile\SweetMember\CMD\WithdrawIntegralCMD $withdrawIntegralCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->withdrawIntegral($withdrawIntegralCMD);
    }

    /**
     * 提交纪念日
     * @return  bool
    */
    public static function submitAnniversary (\Mainto\Bridge\Structs\ProjectCrm\Mobile\SweetMember\CMD\SubmitAnniversaryCMD $submitAnniversaryCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitAnniversary($submitAnniversaryCMD);
    }

    /**
     * 提交纪念日
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function submitAnniversaryBridge (int $userId, string $anniversary, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitAnniversaryBridge(array_merge($_params, ["userId" => $userId, "anniversary" => $anniversary]));
    }

    /**
     * 获取弹框行为
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\SweetMember\DTO\SweetMemberLayerDTO
    */
    public static function getSweetMemberLayer (\Mainto\Bridge\Structs\ProjectCrm\Mobile\SweetMember\CMD\GetSweetMemberLayerCMD $getSweetMemberLayerCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSweetMemberLayer($getSweetMemberLayerCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\SweetMember\DTO\SweetMemberLayerDTO"
        );
    }

    /**
     * 删除行为
     * @return  bool
    */
    public static function deleteBehavior (\Mainto\Bridge\Structs\ProjectCrm\Mobile\SweetMember\CMD\DeleteBehaviorCMD $deleteBehaviorCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteBehavior($deleteBehaviorCMD);
    }

    /**
     * sweet相关配置
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\SweetMember\DTO\SweetMemberSettingDTO
    */
    public static function getSweetMemberSetting () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSweetMemberSetting(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\SweetMember\DTO\SweetMemberSettingDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}