<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-11-23 22:48:46
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\ReunionSeasonActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ReunionSeasonActivity
 * @method joinActivityByParams(array $params) 开启活动
 * @method isJoinedByParams(array $params) 是否已开启活动
 * @method getActivityInfoByParams(array $params) 获取活动信息
 * @method answerQuestionByParams(array $params) 用户答题
 * @method getShareRecordDetailByParams(array $params) 获取分享记录详情
 * @method getUserJoinActivityInfoByParams(array $params) 用户参与活动详情
 * @method inviteeAnswerQuestionByParams(array $params) 受邀人答题
 * @method checkInviteeAnswerQuestionByParams(array $params) 校验受邀人答题
 * @method getUserRewardListByParams(array $params) 当前用户的奖品列表
 * @method saveDeliveryInfoByParams(array $params) 保存收货信息
 * @method getLatestLightUpByInviteeByParams(array $params) 获取最近一条被受邀人点亮的记录详情
 */
class ReunionSeasonActivity {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Mobile\\ReunionSeasonActivity\\ReunionSeasonActivity";

    /**
     * 开启活动
     * @return  bool
    */
    public static function joinActivity (\Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\CMD\JoinActivityCMD $joinActivityCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->joinActivity($joinActivityCMD);
    }

    /**
     * 是否已开启活动
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function isJoined () {
        return RpcClass::getClass(self::$serviceName, self::$className)->isJoined();
    }

    /**
     * 获取活动信息
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\DTO\ActivityInfoDTO
    */
    public static function getActivityInfo () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getActivityInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\DTO\ActivityInfoDTO"
        );
    }

    /**
     * 用户答题
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\DTO\AnswerQuestionResultDTO
    */
    public static function answerQuestion (\Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\CMD\AnswerQuestionCMD $answerQuestionCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->answerQuestion($answerQuestionCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\DTO\AnswerQuestionResultDTO"
        );
    }

    /**
     * 获取分享记录详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\DTO\ShareRecordDetailDTO
    */
    public static function getShareRecordDetail (int $recordId, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getShareRecordDetail(array_merge($_params, ["recordId" => $recordId])),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\DTO\ShareRecordDetailDTO"
        );
    }

    /**
     * 用户参与活动详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\DTO\UserJoinActivityInfoDTO
    */
    public static function getUserJoinActivityInfo () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserJoinActivityInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\DTO\UserJoinActivityInfoDTO"
        );
    }

    /**
     * 受邀人答题
     * @return  bool
    */
    public static function inviteeAnswerQuestion (\Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\CMD\InviteeAnswerQuestionCMD $inviteeAnswerQuestionCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->inviteeAnswerQuestion($inviteeAnswerQuestionCMD);
    }

    /**
     * 校验受邀人答题
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\DTO\InviteeAnswerCheckResultDTO
    */
    public static function checkInviteeAnswerQuestion (\Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\CMD\InviteeAnswerQuestionCheckCMD $inviteeAnswerQuestionCheckCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->checkInviteeAnswerQuestion($inviteeAnswerQuestionCheckCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\DTO\InviteeAnswerCheckResultDTO"
        );
    }

    /**
     * 当前用户的奖品列表
     * @return  array
    */
    public static function getUserRewardList (\Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\CMD\UserRewardListCMD $userRewardListCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserRewardList($userRewardListCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\DTO\UserRewardDetailDTO[]"
        );
    }

    /**
     * 保存收货信息
     * @return  bool
    */
    public static function saveDeliveryInfo (\Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\CMD\SaveDeliveryInfoCMD $saveDeliveryInfoCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveDeliveryInfo($saveDeliveryInfoCMD);
    }

    /**
     * 获取最近一条被受邀人点亮的记录详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\DTO\ShareRecordDetailDTO
    */
    public static function getLatestLightUpByInvitee () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getLatestLightUpByInvitee(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\ReunionSeasonActivity\DTO\ShareRecordDetailDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}