<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-12-03 11:35:02
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\MarketingRule;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class MarketingRuleMessage
 * @method genMarketingRuleUserTicketByParams(array $params) 生成营销规则订单待核销数据
 * @method doTicketVerificationByParams(array $params) 营销规则凭证核销
 * @method abolishMarketingRuleUserRewardsByParams(array $params) 订单退款，作废营销规则发放的优惠券奖励
 */
class MarketingRuleMessage {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Mobile\\MarketingRule\\MarketingRuleMessage";

    /**
     * 生成营销规则订单待核销数据
     * @return  bool
    */
    public static function genMarketingRuleUserTicket (\Mainto\Bridge\Structs\ProjectCrm\Mobile\MarketingRule\CMD\GenMarketingRuleUserTicketCMD $genMarketingRuleUserTicketCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->genMarketingRuleUserTicket($genMarketingRuleUserTicketCMD);
    }

    /**
     * 营销规则凭证核销
     * @return  bool
    */
    public static function doTicketVerification (\Mainto\Bridge\Structs\ProjectCrm\Mobile\MarketingRule\CMD\TicketVerificationCMD $ticketVerificationCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->doTicketVerification($ticketVerificationCMD);
    }

    /**
     * 订单退款，作废营销规则发放的优惠券奖励
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function abolishMarketingRuleUserRewards (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->abolishMarketingRuleUserRewards(["orderId" => $orderId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}