<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-11-27 17:20:50
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\HarryPotterActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class HarryPotterActivity
 * @method getActivityInfoByParams(array $params) 获取活动信息
 * @method openCardByParams(array $params) 用户开卡
 * @method agreeAskForCardByParams(array $params) 用户同意索要卡片
 * @method receiveGiftCardByParams(array $params) 用户领取赠送的卡片
 * @method createShareRecordByParams(array $params) 创建分享记录
 * @method getShareRecordByParams(array $params) 获取分享记录详情
 * @method createInviteCardByParams(array $params) 生成活动邀请函
 * @method answerQuestionByParams(array $params) 回答问题
 * @method confirmCommandByParams(array $params) 提交口令
 * @method compoundCardByParams(array $params) 合成卡片
 * @method saveDeliveryInfoByParams(array $params) 保存收货信息
 * @method getUserRewardListByParams(array $params) 当前用户的奖品列表
 * @method isInviteCardCreatedByParams(array $params) 是否已生成邀请函
 * @method getUserJoinActivityInfoByParams(array $params) 获取当前用户活动参与信息
 */
class HarryPotterActivity {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Mobile\\HarryPotterActivity\\HarryPotterActivity";

    /**
     * 获取活动信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\ActivityInfoDTO
    */
    public static function getActivityInfo () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getActivityInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\ActivityInfoDTO"
        );
    }

    /**
     * 用户开卡
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\CardTemplateDTO
    */
    public static function openCard () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->openCard(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\CardTemplateDTO"
        );
    }

    /**
     * 用户同意索要卡片
     * @return  bool
    */
    public static function agreeAskForCard (\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\CMD\ShareCardCMD $shareCardCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->agreeAskForCard($shareCardCMD);
    }

    /**
     * 用户领取赠送的卡片
     * @return  bool
    */
    public static function receiveGiftCard (\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\CMD\ShareCardCMD $shareCardCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->receiveGiftCard($shareCardCMD);
    }

    /**
     * 创建分享记录
     * @return  int
    */
    public static function createShareRecord (\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\CMD\CreateShareRecordCMD $createShareRecordCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createShareRecord($createShareRecordCMD);
    }

    /**
     * 获取分享记录详情
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\ShareRecordDetailDTO
    */
    public static function getShareRecord (\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\CMD\ShareRecordDetailCMD $shareRecordDetailCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getShareRecord($shareRecordDetailCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\ShareRecordDetailDTO"
        );
    }

    /**
     * 生成活动邀请函
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function createInviteCard (string $nickname, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createInviteCard(array_merge($_params, ["nickname" => $nickname]));
    }

    /**
     * 回答问题
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\AnswerQuestionDTO
    */
    public static function answerQuestion (int $answerId, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->answerQuestion(array_merge($_params, ["answerId" => $answerId])),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\AnswerQuestionDTO"
        );
    }

    /**
     * 提交口令
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\CommandDTO
    */
    public static function confirmCommand (string $command, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->confirmCommand(array_merge($_params, ["command" => $command])),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\CommandDTO"
        );
    }

    /**
     * 合成卡片
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function compoundCard () {
        return RpcClass::getClass(self::$serviceName, self::$className)->compoundCard();
    }

    /**
     * 保存收货信息
     * @return  bool
    */
    public static function saveDeliveryInfo (\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\CMD\SaveDeliveryInfoCMD $saveDeliveryInfoCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveDeliveryInfo($saveDeliveryInfoCMD);
    }

    /**
     * 当前用户的奖品列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getUserRewardList (array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserRewardList(array_merge($_params, [])),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\UserRewardDetailDTO[]"
        );
    }

    /**
     * 是否已生成邀请函
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function isInviteCardCreated () {
        return RpcClass::getClass(self::$serviceName, self::$className)->isInviteCardCreated();
    }

    /**
     * 获取当前用户活动参与信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\UserJoinActivityInfoDTO
    */
    public static function getUserJoinActivityInfo () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserJoinActivityInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\UserJoinActivityInfoDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}