<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-12-21 10:36:16
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ActivityPage
 * @method createActiveByParams(array $params) 创建一个活动
 * @method searchActiveByParams(array $params) 活动查询
 * @method copyActivityPageByIdByParams(array $params) 复制单个活动
 * @method searchByIdByParams(array $params) 单个活动查询
 * @method updateByParams(array $params) 更新活动
 * @method deleteByParams(array $params) 删除活动
 * @method upDownActivePageByParams(array $params) 上线或下线活动
 * @method createPeoplePackByParams(array $params) 创建活动人群包
 * @method createDmpServicePeoplePackByParams(array $params) 创建画像平台活动人群包
 * @method getDmpServicePeoplePackInfoByParams(array $params) 获取画像平台人群包信息
 * @method getDmpGroupListByParams(array $params) 获取画像平台人群包
 */
class ActivityPage {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Manage\\ActivityPage";

    /**
     * 创建一个活动
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function createActive (string $category, string $name, string $template, array $extend, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createActive(array_merge($_params, ["category" => $category, "name" => $name, "template" => $template, "extend" => $extend]));
    }

    /**
     * 活动查询
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function searchActive (int $page = 1, int $page_size = 10, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchActive(array_merge($_params, ["page" => $page, "page_size" => $page_size]));
    }

    /**
     * 复制单个活动
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function copyActivityPageById (string $_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->copyActivityPageById(array_merge($_params, ["_id" => $_id]));
    }

    /**
     * 单个活动查询
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function searchById (string $_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchById(["_id" => $_id]);
    }

    /**
     * 更新活动
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function update (string $_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(array_merge($_params, ["_id" => $_id]));
    }

    /**
     * 删除活动
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function delete (string $_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["_id" => $_id]);
    }

    /**
     * 上线或下线活动
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function upDownActivePage (string $_id, string $page_state) {
        return RpcClass::getClass(self::$serviceName, self::$className)->upDownActivePage(["_id" => $_id, "page_state" => $page_state]);
    }

    /**
     * 创建活动人群包
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\ActivityPage\DTO\ActivityPeopleGroupPackDTO
    */
    public static function createPeoplePack (string $file_url) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createPeoplePack(["file_url" => $file_url]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\ActivityPage\DTO\ActivityPeopleGroupPackDTO"
        );
    }

    /**
     * 创建画像平台活动人群包
     * @return  int
    */
    public static function createDmpServicePeoplePack (\Mainto\Bridge\Structs\ProjectCrm\Manage\ActivityPage\CMD\CreateDmpServicePeoplePackCMD $createDmpServicePeoplePackCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createDmpServicePeoplePack($createDmpServicePeoplePackCMD);
    }

    /**
     * 获取画像平台人群包信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\ActivityPage\DTO\DmpServicePeoplePackInfoDTO
    */
    public static function getDmpServicePeoplePackInfo (int $peoplePackId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getDmpServicePeoplePackInfo(["peoplePackId" => $peoplePackId]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\ActivityPage\DTO\DmpServicePeoplePackInfoDTO"
        );
    }

    /**
     * 获取画像平台人群包
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\ActivityPage\DTO\DmpGroupListDTO
    */
    public static function getDmpGroupList (?\Mainto\Bridge\Structs\ProjectCrm\Manage\ActivityPage\CMD\DmpGroupListCMD $dmpGroupListCMD = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getDmpGroupList($dmpGroupListCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\ActivityPage\DTO\DmpGroupListDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}